let devTools;
let devBool = false;

let stopMarks = [];

let activeLocationText;

let xPosVal;
let zPosVal;

let xRotVal;
let yRotVal;
let zRotVal;

let touchPivotEl;

let xRotLessButton;
let xRotMoreButton;
let yRotLessButton;
let yRotMoreButton;
let zRotLessButton;
let zRotMoreButton;

let xPosLessButton;
let xPosMoreButton;
let yPosLessButton;
let yPosMoreButton;
let zPosLessButton;
let zPosMoreButton;

function devinit() {
    // cameraParent = document.getElementById('cameraParent');
    scene = document.querySelector('a-scene');
    scene.addEventListener('loaded', () => { setTimeout(OnAframeLoadDev(), 1000)});
    // sceneLoadTimeout = setTimeout(() => {
    //     OnAframeLoadDev();
    // }, 8000);
    
    devTools = document.getElementsByClassName('dev-tools');
    stopMarks = document.getElementsByClassName('stop-mark');

    for(var i = 0; i < stopMarks.length; i++)
    {
        cameraParent.addEventListener("playerTransitioned", () => {
            UpdatePositionText();
            UpdateRotationText();
        })
    }

    document.body.innerHTML = '<div id="horizonLine" class="dev-tools"></div> <div id="vertLine" class="dev-tools"></div> <h2 id="activeLocation" class="dev-tools">Location: </h2> <div id="rotationControlGroup" class="control-group dev-tools">Rotation <div id="xRotationControl" class="val-control"> <div id="xRotLess" class="val-button">-</div> <div id="xRotMore" class="val-button">+</div> <div id="xRotVal" class="val-text"></div> </div> <div id="yRotationControl" class="val-control"> <div id="yRotLess" class="val-button">-</div> <div id="yRotMore" class="val-button">+</div> <div id="yRotVal" class="val-text"></div> </div> <div id="zRotationControl" class="val-control"> <div id="zRotLess" class="val-button">-</div> <div id="zRotMore" class="val-button">+</div> <div id="zRotVal" class="val-text"></div> </div> </div> <div id="positionControlGroup" class="control-group dev-tools">Position <div id="xPositionControl" class="val-control"> <div id="xPosLess" class="val-button">-</div> <div id="xPosMore" class="val-button">+</div> <div id="xPosVal" class="val-text"></div> </div> <div id="zPositionControl" class="val-control "> <div id="zPosLess" class="val-button">-</div> <div id="zPosMore" class="val-button">+</div> <div id="zPosVal" class="val-text"></div> </div> </div> <div id="locationList" class="dev-tools"> <ol id="locationOL" start="0"> <li>Entry Well</li> <li>Drink Cooler 3</li> <li>Drink Cooler 2</li> <li>Snacks 2</li> <li>Fizz City</li> <li>Snacks</li> <li>Center 2</li> <li>Entry</li> <li>Beer Cave - Outside</li> <li>MTO Screen</li> <li>Register - CBD</li> <li>Register - Tobacco</li> <li>Bakery</li> <li>Coffee</li> <li>Bathroom - Outside</li> <li>Bathroom - Inside</li> <li>Beer Cave - Inside</li> <li>Register - SFTK</li> <li>MTO 1</li> <li>MTO 2</li> <li>Drink Pickup</li> <li>Seating</li> <li>RTE Display Case</li> <li>Front Entrance - Left</li> <li>Front Entrance - Right</li> <li>Font Corner</li> <li>Curbside Pickup</li> <li>Side - Outdoor Seating</li> <li>Back Corner</li> <li>Drive Through 1</li> <li>Drive Through 2</li> <li>Gas Pump</li> <li>Free Air</li> <li>Carwash - Side</li> <li>Carwash - Terminal</li> <li>Carwash - Inside</li> <li>Carwash - Exit</li> </ol> </div>' + document.body.innerHTML;

    // DEV TOOLS
    window.addEventListener("keydown", function (event) {
        if (event.key == 't') { 
            ToggleDevTools();
        }
    }, true);
}

function OnAframeLoadDev()
{
    if(!aFrameLoaded)
    {
        aFrameLoaded = true;
        console.log('AFRAME loaded')
        skybox = document.getElementById('skybox');

        // DEBUG
        activeLocationText = document.getElementById('activeLocation');

        xRotLessButton = document.getElementById('xRotLess');
        xRotMoreButton = document.getElementById('xRotMore');
        yRotLessButton = document.getElementById('yRotLess');
        yRotMoreButton = document.getElementById('yRotMore');
        zRotLessButton = document.getElementById('zRotLess');
        zRotMoreButton = document.getElementById('zRotMore');

        xRotLessButton.addEventListener('click', xRotLess);
        xRotMoreButton.addEventListener('click', xRotMore);
        yRotLessButton.addEventListener('click', yRotLess);
        yRotMoreButton.addEventListener('click', yRotMore);
        zRotLessButton.addEventListener('click', zRotLess);
        zRotMoreButton.addEventListener('click', zRotMore);

        xPosLessButton = document.getElementById('xPosLess');
        xPosMoreButton = document.getElementById('xPosMore');
        zPosLessButton = document.getElementById('zPosLess');
        zPosMoreButton = document.getElementById('zPosMore');

        xPosLessButton.addEventListener('click', xPosLess);
        xPosMoreButton.addEventListener('click', xPosMore);
        zPosLessButton.addEventListener('click', zPosLess);
        zPosMoreButton.addEventListener('click', zPosMore);

        touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');

        xPosVal = document.getElementById('xPosVal');
        zPosVal = document.getElementById('zPosVal');

        xRotVal = document.getElementById('xRotVal');
        yRotVal = document.getElementById('yRotVal');
        zRotVal = document.getElementById('zRotVal');

        xPosVal.innerText = String(touchPivotEl.getAttribute('position').x.toFixed(2));
        zPosVal.innerText = String(touchPivotEl.getAttribute('position').z.toFixed(2));

        UpdatePositionText();
        UpdateRotationText();
    }
}

function ToggleDevTools()
{
    if(devBool)
    {
        for(var i = 0; i < devTools.length; i++)
        {
            devTools[i].style.visibility = 'hidden';
        }
        devBool = false;
    }
    else
    {
        for(var i = 0; i < devTools.length; i++)
        {
            devTools[i].style.visibility = 'visible';
        }
        devBool = true;
    }
}

function xRotLess()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var xVal = touchPointEl.getAttribute('location-asset').xRotation;
    touchPointEl.setAttribute('location-asset', { 'xRotation': (xVal-0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}
function xRotMore()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var xVal = touchPointEl.getAttribute('location-asset').xRotation;
    touchPointEl.setAttribute('location-asset', { 'xRotation': (xVal+0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}
function yRotLess()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var yVal = touchPointEl.getAttribute('location-asset').yRotation;
    touchPointEl.setAttribute('location-asset', { 'yRotation': (yVal-0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}
function yRotMore()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var yVal = touchPointEl.getAttribute('location-asset').yRotation;
    touchPointEl.setAttribute('location-asset', { 'yRotation': (yVal+0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}
function zRotLess()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var zVal = touchPointEl.getAttribute('location-asset').zRotation;
    touchPointEl.setAttribute('location-asset', { 'zRotation': (zVal-0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}
function zRotMore()
{
    touchPointEl = document.getElementById(activeTouchPoint.substring(1) + '_point');
    var zVal = touchPointEl.getAttribute('location-asset').zRotation;
    touchPointEl.setAttribute('location-asset', { 'zRotation': (zVal+0.1) });
    skybox.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    skyboxTransition.setAttribute('rotation', 
        String(touchPointEl.getAttribute('location-asset').xRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').yRotation) 
        + " " + String(touchPointEl.getAttribute('location-asset').zRotation) );
    UpdateRotationText()
}

function UpdateRotationText()
{
    // Debug
    xRotVal = document.getElementById('xRotVal');
    yRotVal = document.getElementById('yRotVal');
    zRotVal = document.getElementById('zRotVal');

    xRotVal.innerText = String(skybox.getAttribute('rotation').x.toFixed(2));
    yRotVal.innerText = String(skybox.getAttribute('rotation').y.toFixed(2));
    zRotVal.innerText = String(skybox.getAttribute('rotation').z.toFixed(2));
}

function xPosLess()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var xVal = touchPivotEl.getAttribute('position').x;
    touchPivotEl.object3D.position.x = (xVal-0.01);
    cameraParent.object3D.position.x = (xVal-0.01);
    skybox.object3D.position.x = (xVal-0.01);
    UpdatePositionText()
}
function xPosMore()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var xVal = touchPivotEl.getAttribute('position').x;
    touchPivotEl.object3D.position.x = (xVal+0.01);
    cameraParent.object3D.position.x = (xVal+0.01);
    skybox.object3D.position.x = (xVal+0.01);
    UpdatePositionText()
}
function yPosLess()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var yVal = touchPivotEl.getAttribute('position').y;
    touchPivotEl.object3D.position.y = (yVal-0.05);
    UpdatePositionText()
}
function yPosMore()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var yVal = touchPivotEl.getAttribute('position').y;
    touchPivotEl.object3D.position.y = (yVal+0.05);
    UpdatePositionText()
}
function zPosLess()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var zVal = touchPivotEl.getAttribute('position').z;
    touchPivotEl.object3D.position.z = (zVal-0.01);
    cameraParent.object3D.position.z = (zVal-0.01);
    skybox.object3D.position.z = (zVal-0.01);
    UpdatePositionText()
}
function zPosMore()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    var zVal = touchPivotEl.getAttribute('position').z;
    touchPivotEl.object3D.position.z = (zVal+0.01);
    cameraParent.object3D.position.z = (zVal+0.01);
    skybox.object3D.position.z = (zVal+0.01);
    UpdatePositionText()
}

function UpdatePositionText()
{
    touchPivotEl = document.getElementById(activeTouchPoint.substring(1) + '_pivot');
    xPosVal = document.getElementById('xPosVal');
    zPosVal = document.getElementById('zPosVal');

    xPosVal.innerText = String(touchPivotEl.object3D.position.x.toFixed(2));
    zPosVal.innerText = String(touchPivotEl.object3D.position.z.toFixed(2));

    activeLocationText.innerText = activeTouchPoint;
}

window.onload = setTimeout(() => { devinit(); }, 1000);