
let whiteMaterial;
let redMaterial;

var envMapTex = new THREE.TextureLoader().load( './images/textures/adams_place_bridge_1k.jpg' );
var diffuseMap = new THREE.TextureLoader().load( './images/textures/SheetzCoin_Diffuse.png' );
	  
whiteMaterial  = new THREE.MeshPhysicalMaterial({
    color: '#fff',
    metalness : 0,
    roughness : 0.2,
    skinning : true,
    envMap: envMapTex,
    envMapIntensity: 0.3,
    transparent: true,
    side: THREE.FrontSide,
    opacity: 0,
});

redMaterial  = new THREE.MeshPhysicalMaterial({
    map: diffuseMap,
    // color: '#C10230',
    metalness : 0,
    roughness : 0.2,
    skinning : true,
    envMap: envMapTex,
    envMapIntensity: 0.3,
    transparent: true,
    side: THREE.FrontSide,
    opacity: 0,
});

AFRAME.registerComponent('coin-material', {
	init: function () {

        this.el.addEventListener('model-loaded', () => {
            // Grab the mesh / scene.
            const obj = this.el.getObject3D('mesh');
            // Go over the submeshes and modify materials we want.
            obj.traverse(node => {
                // if(node.isMesh)
                // {
                //     node.geometry.boundingSphere.radius = Number.MAX_VALUE;
                // }
                if(node.isMesh && node.name.includes("Icon_Red")) {
                    node.material = redMaterial;
                    node.castShadow = true;
                    // node.receiveShadow = false;
                    node.renderOrder = 1;
                }
                else if(node.isMesh) {
                    node.material = whiteMaterial;
                    node.castShadow = true;
                    // node.receiveShadow = false;
                    node.renderOrder = 1;
                }
            });
        });
      
    }
})