
AFRAME.registerComponent('occlusion-material', {
    init: function () {

        this.occlusionMaterial  = new THREE.MeshBasicMaterial({
            color: '#ddd',
            opacity: 0,
            transparent: true,
            depthTest: true,
            depthWrite: true,
        });

        this.el.addEventListener('model-loaded', () => {
            // Grab the mesh / scene.
            const obj = this.el.getObject3D('mesh');
            // Go over the submeshes and modify materials we want.
            obj.traverse(node => {
                if(node.isMesh) {
                    node.material = this.occlusionMaterial;
                    node.castShadow = false;
                    node.receiveShadow = true;
                }
            });
        });
    }
  });