
AFRAME.registerComponent('experience-control', {
    schema: {
    rayclass: { type: 'string', default: 'cantap' }
    },
    init: function () {

        var camera = this.el;
        var rayClass = this.data.rayclass;

        camera.setAttribute('raycaster', { objects: '.' + rayClass });
        camera.setAttribute('cursor', { fuse: false, rayOrigin: 'mouse' });
    }
});

AFRAME.registerComponent('touch-point-location', {
    schema: {
        name: { type: 'string', default: 'tp' },
        type: { type: 'string', default: 'cross' },
        active: { type: 'bool', default: true },
        scoped: { type: 'bool', default: true },
        transitionInProgress: { type: 'bool', default: false },
        transitionComplete: { type: 'bool', default: false },
    },
    init: function () {

        var touchPoint = this.el;
        var data = this.data;
        var targetLocation = document.getElementById(data.name.substring(1) + "_point");
        var camera = document.getElementById('camera');
        var cameraParent = document.getElementById('cameraParent');
        var blackoutOverlay = document.getElementById('blackoutOverlay');
        var skyboxBase = document.getElementById('skyboxBase');
        var skyboxTransition = document.getElementById('skyboxTransition');
        var rayClass = camera.getAttribute('experience-control').rayclass;
        var cameraEvent = new CustomEvent('playerTransitioned');

        // data.touchEl = touchPoint;

        if (!touchPoint.classList.contains(rayClass) && data.active) {
            touchPoint.classList.add(rayClass);
        }


        touchPoint.addEventListener('click', function (e) {
            if(!mouseMoved && !data.transitionInProgress)
            {
                var event = new CustomEvent('locationTransition', { 'detail': data });
                var videoStopsArray;
                if(touchPoint.components.hasOwnProperty('touch-point-video'))
                {
                    videoStopsArray = touchPoint.getAttribute('touch-point-video').videoStops.split(" ");
                }
                
                if(data.type != "videoTransition" && activeTouchPoint != data.name)
                {
                    data.transitionInProgress = true;
                    document.getElementById(activeTouchPoint.substring(1) + "_point").setAttribute('touch-point-location', { transitionComplete: false });

                    if (data.scoped) {
                        touchPoint.dispatchEvent(event);
                        cameraParent.dispatchEvent(cameraEvent);
                    }
                    else {
                        document.dispatchEvent(event);
                        cameraParent.dispatchEvent(cameraEvent);
                    }
                }
    
                if(data.type == "videoTransition")
                {
                    if(!videoStopsArray.includes(activeTouchPoint))
                    {
                        data.transitionInProgress = true;
                        document.getElementById(data.name.substring(1) + "_point").setAttribute('touch-point-location', { transitionComplete: false });
                        SkyboxFadeTransition();

                        if (data.scoped) {
                            touchPoint.dispatchEvent(event);
                            cameraParent.dispatchEvent(cameraEvent);
                        }
                        else {
                            document.dispatchEvent(event);
                            cameraParent.dispatchEvent(cameraEvent);
                        }
                    }
                    else
                    {
                        document.getElementById(activeTouchPoint.substring(1) + "_point").setAttribute('touch-point-location', { transitionComplete: true });
                        data.transitionInProgress = false;
                    }
                }
                else if(data.type == "fadeInOut")
                {
                    SkyboxFadeTransition();
                }
                else
                {
                    SkyboxCrossFadeTransition();
                }
            }
        })

        var worldPos = new THREE.Vector3();

        function SkyboxFadeTransition()
        {
            skyboxBase.emit('fadeout');
            blackoutOverlay.classList.add('active');

            setTimeout(() => {
                skyboxBase.setAttribute('src', targetLocation.getAttribute('location-asset').id);
                var worldPos = new THREE.Vector3();
                targetLocation.object3D.getWorldPosition(worldPos);

                cameraParent.setAttribute('position', 
                    String(worldPos.x) 
                    + " 0 " 
                    + String(worldPos.z));
                skyboxBase.setAttribute('rotation', 
                    String(targetLocation.getAttribute('location-asset').xRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').yRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').zRotation) );
                skyboxBase.setAttribute('position', String(worldPos.x) + " 1.6 " + String(worldPos.z) );

                skyboxTransition.setAttribute('rotation', 
                    String(targetLocation.getAttribute('location-asset').xRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').yRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').zRotation) );
                skyboxTransition.setAttribute('position', String(worldPos.x) + " 1.6 " + String(worldPos.z) );
                skyboxTransition.setAttribute('src', targetLocation.getAttribute('location-asset').id);

            }, 200);
            setTimeout(() => {
                skyboxBase.emit('fadein');
            }, 250);
            setTimeout(() => {
                blackoutOverlay.classList.remove('active');
                document.getElementById(data.name.substring(1) + "_point").setAttribute('touch-point-location', { transitionComplete: true });
                data.transitionInProgress = false;
            }, 500);
        }

        function SkyboxCrossFadeTransition()
        {
            baseMarkerMesh.emit('fadeOut');
            dropShadowMesh.emit('fadeOut');
            baseCoinMesh.emit('fadeOut');
            for(var i = 0; i < transitionSigns.length; i++)
            {
                transitionSigns[i].emit('fadeOut');
            }

            var worldPos = new THREE.Vector3();
            targetLocation.object3D.getWorldPosition(worldPos);

            var targetDistance = distanceVector( worldPos, skyboxBase.object3D.position );
            var clampedDistance = Math.max(targetDistance*1.15, 5);
            // console.log(clampedDistance);

            skyboxBase.setAttribute('opacity', 1);
            skyboxTransition.emit('fadein');

            skyboxTransition.setAttribute('radius', clampedDistance);
            skyboxBase.setAttribute('radius', clampedDistance);
            
            skyboxBase.setAttribute('rotation', 
                    String(targetLocation.getAttribute('location-asset').xRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').yRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').zRotation) );
            skyboxBase.setAttribute('position', String(worldPos.x) + " 1.6 " + String(worldPos.z) );
            skyboxBase.setAttribute('src', targetLocation.getAttribute('location-asset').id);

            TransitionCamera(cameraParent.object3D.position, worldPos);

            setTimeout(() => {
                skyboxTransition.emit('fadeout');
                camera.emit('fovin');
            }, 100);
            setTimeout(() => {
                camera.emit('fovout');
            }, 550);
            setTimeout(() => {
                baseMarkerMesh.emit('fadeIn');
                dropShadowMesh.emit('fadeIn');
                baseCoinMesh.emit('fadeIn');
                for(var i = 0; i < transitionSigns.length; i++)
                {
                    transitionSigns[i].emit('fadeIn');
                }
            }, 550);

            setTimeout(() => {
                // CROSS FADE TRANSITION
                skyboxTransition.setAttribute('rotation', 
                    String(targetLocation.getAttribute('location-asset').xRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').yRotation) 
                    + " " + String(targetLocation.getAttribute('location-asset').zRotation) );
                skyboxTransition.setAttribute('position', String(worldPos.x) + " 1.6 " + String(worldPos.z) );
                skyboxTransition.setAttribute('src', targetLocation.getAttribute('location-asset').id);

                // console.log("Setting Camera to: " + String(worldPos.x) + " 1.6 " + String(worldPos.z))
                skyboxTransition.setAttribute('material.opacity', 1);

                document.getElementById(data.name.substring(1) + "_point").setAttribute('touch-point-location', { transitionComplete: true });
                data.transitionInProgress = false;
            }, 1000);
        }
        
        function TransitionCamera(cameraPos, newPos)
        {
            cameraParent.setAttribute('animation__movecamera', {
                property: 'position',
                from: cameraPos.x + " " + cameraPos.y + " " + cameraPos.z,
                to: newPos.x + " " + newPos.y + " " + newPos.z,
                dur: 1000,
                easing: "easeInOutCubic",
                startEvents: 'transitionCamera'
            })

            cameraParent.emit('transitionCamera');
        }
    }
});

AFRAME.registerComponent('touch-point-video', {
    schema: {
        name: { type: 'string', default: 'tp' },
        type: { type: 'string', default: '' },
        active: { type: 'bool', default: true },
        scoped: { type: 'bool', default: true },
        video: { type: 'string', default: '' },
        videoStops: { type: 'string', default: "" },
        firstTime: { type: 'bool', default: true },
        videoSuccess: { type: 'bool', default: true },
    },
    init: function () {

        var touchPoint = this.el;
        var data = this.data;
        var camera = document.getElementById('camera');
        var rayClass = camera.getAttribute('experience-control').rayclass;

        var videoAsset = document.querySelector('#' + data.video);
        var audioAsset = document.querySelector('#spinAudio');
        let videoStopsArray = data.videoStops.split(" ");

        if (!touchPoint.classList.contains(rayClass) && data.active) {
            touchPoint.classList.add(rayClass);
        }

        touchPoint.addEventListener('click', function (e) {
            if(!mouseMoved)
            {
                data.videoSuccess = true;
                // if(!videoIsPlaying && videoStopsArray.includes(activeTouchPoint))
                // {
                // }
                if(data.firstTime)
                {
                    var source;
                    if(!iOSOrSafari)
                    {
                        source = videoAsset.children[0];
                    }
                    else
                    {
                        source = videoAsset.children[1];
                    }
                    source.onerror = function(event) {
                        audioAsset.pause();
                        document.getElementById('errorMessage').classList.add('show-message');
                        data.videoSuccess = false;

                        var event = new CustomEvent('touchPointVideo', { 'detail': data });
                        if (data.scoped) {
                            touchPoint.dispatchEvent(event);
                        }
                        else {
                            document.dispatchEvent(event);
                        }
                    }
                }

                // audioAsset.loop = true;
                audioAsset.currentTime = 0;
                audioAsset.volume = 1;
                audioAsset.play();
                videoAsset.currentTime = 0;
                videoAsset.muted = true;
                if (iOSOrSafari) {
                    console.log("Video Playing");
                    videoAsset.play()
                }
                else
                {
                    console.log("Video Loading");
                    // console.log("In Chrome or Android");
                    videoAsset.load()
                }

                if(data.videoSuccess)
                {
                    var event = new CustomEvent('touchPointVideo', { 'detail': data });
                    if (data.scoped) {
                        touchPoint.dispatchEvent(event);
                    }
                    else {
                        document.dispatchEvent(event);
                    }
                }
            }
        }, false)
    },
    tick: function() {
        var audioAsset = document.querySelector('#spinAudio');
        if(videoIsLoading && audioAsset.currentTime > 0.8)
        {
            audioAsset.currentTime = 0.4;
        }
    }
});

AFRAME.registerComponent('touch-point-video-plane', {
    schema: {
        name: { type: 'string', default: 'tp' },
        type: { type: 'string', default: '' },
        active: { type: 'bool', default: true },
        coin: { type: 'string', default: '' },
    },
    init: function () {

        var touchPoint = this.el;
        var data = this.data;
        var coin = document.getElementById(data.coin);

        touchPoint.addEventListener('click', function (e) {
            if(!mouseMoved)
            {
                var event = new CustomEvent('touchPointVideo', { 'detail': data });
                coin.dispatchEvent(event);
            }
        }, false)
    }
});

AFRAME.registerComponent('set-camera', {
    schema: {
        pitchRotation: { type: 'number', default: 0 },
        yawRotation: { type: 'number', default: 0 },
        videoStops: {  }
    },
    init: function () {

        var el = this.el;
        var data = this.data;
        var cameraParent = document.getElementById('cameraParent');
        var camera = document.getElementById('camera');

        el.addEventListener('click', function (e) {
            if(!mouseMoved)
            {
                var isComplete = false;
                var videoStopsArray = "";
                if(el.components.hasOwnProperty('touch-point-video'))
                {
                    videoStopsArray = el.getAttribute('touch-point-video').videoStops.split(" ");
                }
                // document.getElementById(activeTouchPoint.substring(1) + "_point").getAttribute('touch-point-location').transitionComplete;
                if(videoStopsArray != "")
                {
                    for(var i = 0; i < videoStopsArray.length; i++)
                    {
                        if(document.getElementById(activeTouchPoint.substring(1) + "_point").getAttribute('touch-point-location').transitionComplete)
                        {
                            isComplete = true;       
                        }
                    }
                }
                if(!isComplete)
                {
                    setTimeout(() => {
                        if(camera.components["custom-look-controls"].hasOwnProperty('magicWindowControls'))
                        {
                            camera.components["custom-look-controls"].magicWindowControls.enabled = false
                            camera.components["custom-look-controls"].magicWindowDeltaEuler._y = 0
                            // camera.components["custom-look-controls"].yawObject.rotation.y = data.yawRotation * (Math.PI/180);
                            camera.components["custom-look-controls"].magicWindowControls.enabled = true
                            // controls = new DeviceOrientationControls( camera );
                        }
                        camera.components["custom-look-controls"].yawObject.rotation.y = 0;
                        cameraParent.setAttribute('rotation', '0 '+data.yawRotation+' 0');
                        // camera.components["look-controls"].pitchObject.rotation.x = data.pitchRotation;
                    }, 200);
                }
            }
        })
    }
});

function distanceVector( v1, v2 )
{
    var dx = v1.x - v2.x;
    var dy = v1.y - v2.y;
    var dz = v1.z - v2.z;

    return Math.sqrt( dx * dx + dy * dy + dz * dz );
}